#ifndef _NEW_COMMON_H_
#define _NEW_COMMON_H_

#define NO			0
#define YES			1

#define OFF			0
#define ON			1

#ifndef NULL
	#define NULL				0
#endif

#ifndef FALSE
	#define FALSE				0
#endif
#ifndef TRUE
	#define TRUE				1
#endif

#define SYSTEM_PC_COUNT							1
#define SYSTEM_HCB_COUNT						1
#define SYSTEM_SPB_COUNT						6
#define SYSTEM_SPB_MAX_COUNT					6
#define SYSTEM_SPB_CAMERA_COUNT					3
#define SYSTEM_SPB_CAMERA_MAX_COUNT				4
#define SYSTEM_CPB_COUNT						32
#define SYSTEM_CPB_MAX_COUNT					32
#define SYSTEM_CPB_CPU_COUNT					8
#define SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT		8
//#define SYSTEM_TOTAL_CAMERA_COUNT		(SYSTEM_SPB_COUNT * SYSTEM_SPB_CAMERA_COUNT)
#define SYSTEM_TOTAL_CAMERA_COUNT				16

#define SYSTEM_TOTAL_LED_COUNT					12
#define SYSTEM_MACHINE_CAPTURE_COUNT			6

#define SYSTEM_CAMERA_WIDTH						640
#define SYSTEM_CAMERA_HEIGHT					480

#define SYSTEM_CAMERA_WIDTH_3D					512
#define SYSTEM_CAMERA_HEIGHT_3D					360

#define IMAGE_WIDTH_3D							320
#define IMAGE_HEIGHT_3D							480

#define IMAGE_WIDTH_2D							640
#define IMAGE_HEIGHT_2D							480


/************************************************************************************/
/*  Bit а   												*/
/************************************************************************************/

#define BIT32_GET(VAR,FIELD) (unsigned int)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define BIT32_SET(VAR,FIELD,Val) VAR=(unsigned int)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned int)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK) \
)

#define BIT16_GET(VAR,FIELD) (unsigned short)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define BIT16_SET(VAR,FIELD,Val) VAR=(unsigned short)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned short)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK) \
)

#define BIT8_GET(VAR,FIELD) (unsigned char)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define BIT8_SET(VAR,FIELD,Val) VAR=(unsigned char)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned char)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK) \
)

#define BOARD_ID_PC				0x8000
#define BOARD_ID_PCI			0x4000
#define BOARD_ID_HCB(s)			((s & 0x03) << 13)	// s = 1 ~ 3	
#define BOARD_ID_SPB(s)			((s & 0x3F) << 6)	// s = 1 ~ 31
#define BOARD_ID_CPB(c)			(c & 0x3F)			// c = 1 ~ 31
#define BOARD_ID_SPB_CPB(s, c)	(((s) << 6) + (c))	// s, c = 1 ~ 31

// program ID for flash
#define PROGRAMINFO_PROGRAMKIND_MONITOR			(('M' << 8) | 'O')  /// 4D00 | 004F = 4D4F(01001101 01001111)
#define PROGRAMINFO_PROGRAMKIND_APPLICATION_4		(('A' << 8) | '4')
#define PROGRAMINFO_PROGRAMKIND_APPLICATION_TABLET_5		(('A' << 8) | '2')
#define PROGRAMINFO_PROGRAMKIND_APPLICATION_CAPSULE_5		(('A' << 8) | '3')

#define PROGRAMINFO_BOARDKIND_HCB				'H'
#define PROGRAMINFO_BOARDKIND_SPB				'S'
#define PROGRAMINFO_BOARDKIND_CPB				'C'

#define PID_BOOT_RECORD		(('B' << 16) | ('0' << 8) | '0')

#define PID_HCB_MONITOR		((PROGRAMINFO_BOARDKIND_HCB << 16) | PROGRAMINFO_PROGRAMKIND_MONITOR)
#define PID_HCB_APPLICATION_ALL_4	PID_HCB_MONITOR
#define PID_HCB_APPLICATION_TABLET_5	((PROGRAMINFO_BOARDKIND_HCB << 16) | PROGRAMINFO_PROGRAMKIND_APPLICATION_TABLET_5)
#define PID_HCB_APPLICATION_CAPSULE_5	((PROGRAMINFO_BOARDKIND_HCB << 16) | PROGRAMINFO_PROGRAMKIND_APPLICATION_CAPSULE_5)

#define PID_SPB				(PROGRAMINFO_BOARDKIND_SPB << 16)
#define PID_HCB				(PROGRAMINFO_BOARDKIND_HCB << 16)
#define PID_CPB				(PROGRAMINFO_BOARDKIND_CPB << 16)

#define PID_SPB_TABLET_4	  	(PID_SPB | ('0' << 8) | '0')
#define PID_SPB_CAPSULE_4	  	(PID_SPB | ('1' << 8) | '0')
#define PID_SPB_TABLET_5   		(PID_SPB | ('2' << 8) | '0')
#define PID_SPB_CAPSULE_5  		(PID_SPB | ('3' << 8) | '0')

#define PID_CPB_TABLET_4	  	(PID_CPB | ('0' << 8) | '0')
#define PID_CPB_CAPSULE_4	  	(PID_CPB | ('1' << 8) | '0')
#define PID_CPB_TABLET_5	  	(PID_CPB | ('2' << 8) | '0')
#define PID_CPB_CAPSULE_5	  	(PID_CPB | ('3' << 8) | '0')

// 2015.03.23     SPB α׷ʹ ÷ ޸𸮿  ½ ϴ ױװ Ѵ.
//  Ⱓ (4.0) α׷   ȹ ֱ  α׷   ױװ ߺ ʵ ϱ  ġ.

/* 3.2  PID */
#define PID_HCB_DB_HEADER_T_3	    	(('D' << 24) | ('H' << 16) | ('T' << 8) | '3')
#define PID_SPB_DB_HEADER_T_3	    	(('D' << 24) | ('H' << 16) | ('T' << 8) | '3')
#define PID_HCB_MS_HEADER_T_3	    	(('M' << 24) | ('H' << 16) | ('T' << 8) | '3')
#define PID_SYSTEM_T_3		  	    	(('S' << 24) | ('S' << 16) | ('T' << 8) | '3')
#define PID_ENVIRONMENT_T_3		    	(('E' << 24) | ('V' << 16) | ('T' << 8) | '3')
#define PID_PORT_MAP_T_3		      	(('P' << 24) | ('M' << 16) | ('T' << 8) | '3')
#define PID_MACHINE_INFO_T_3  	  	(('M' << 24) | ('I' << 16) | ('T' << 8) | '3')
#define PID_USER_MACHINE_ENV_T_3	  (('U' << 24) | ('E' << 16) | ('T' << 8) | '3')
#define PID_RANGER_CAMERA_BASE_T_3	(('R' << 24) | ('B' << 16) | ('T' << 8) | '3')
#define PID_RANGER_CAMERA_T_3	    	(('R' << 24) | ('C' << 16) | ('T' << 8) | '3')
#define PID_TERMINATION_INFO_T_3  	(('T' << 24) | ('I' << 16) | ('T' << 8) | '3')

/* 5.0  PID */
#define PID_HCB_DB_HEADER_T_5		    (('D' << 24) | ('H' << 16) | ('T' << 8) | '5')
#define PID_SPB_DB_HEADER_T_5		    (('D' << 24) | ('H' << 16) | ('T' << 8) | '5')
#define PID_HCB_MS_HEADER_T_5       (('M' << 24) | ('H' << 16) | ('T' << 8) | '5')
#define PID_SYSTEM_T_5				      (('S' << 24) | ('S' << 16) | ('T' << 8) | '5')
#define PID_ENVIRONMENT_T_5		      (('E' << 24) | ('V' << 16) | ('T' << 8) | '5')
#define PID_PORT_MAP_T_5			      (('P' << 24) | ('M' << 16) | ('T' << 8) | '5')
#define PID_MACHINE_INFO_T_5        (('M' << 24) | ('I' << 16) | ('T' << 8) | '5')
#define PID_USER_MACHINE_ENV_T_5    (('U' << 24) | ('E' << 16) | ('T' << 8) | '5')
#define PID_RANGER_CAMERA_BASE_T_5  (('R' << 24) | ('B' << 16) | ('T' << 8) | '5')
#define PID_RANGER_CAMERA_T_5       (('R' << 24) | ('C' << 16) | ('T' << 8) | '5')
#define PID_TERMINATION_INFO_T_5    (('T' << 24) | ('I' << 16) | ('T' << 8) | '5')


/* 5.0 ĸ PID */
#define PID_HCB_DB_HEADER_C_5		    (('D' << 24) | ('H' << 16) | ('C' << 8) | '5')
#define PID_SPB_DB_HEADER_C_5		    (('D' << 24) | ('H' << 16) | ('C' << 8) | '5')
#define PID_HCB_MS_HEADER_C_5		    (('M' << 24) | ('H' << 16) | ('C' << 8) | '5')
#define PID_SYSTEM_C_5              (('S' << 24) | ('S' << 16) | ('C' << 8) | '5')
#define PID_ENVIRONMENT_C_5         (('E' << 24) | ('V' << 16) | ('C' << 8) | '5')
#define PID_PORT_MAP_C_5            (('P' << 24) | ('M' << 16) | ('C' << 8) | '5')
#define PID_MACHINE_INFO_C_5        (('M' << 24) | ('I' << 16) | ('C' << 8) | '5')
#define PID_USER_MACHINE_ENV_C_5    (('U' << 24) | ('E' << 16) | ('C' << 8) | '5')
#define PID_RANGER_CAMERA_BASE_C_5  (('R' << 24) | ('B' << 16) | ('C' << 8) | '5')
#define PID_RANGER_CAMERA_C_5       (('R' << 24) | ('C' << 16) | ('C' << 8) | '5')
#define PID_TERMINATION_INFO_C_5    (('T' << 24) | ('I' << 16) | ('C' << 8) | '5')


#ifdef VER5
	#ifdef PID_TYPE_CAPSULE
		#define PID_HCB_DB_HEADER	        	PID_HCB_DB_HEADER_C_5
		#define PID_SPB_DB_HEADER	        	PID_SPB_DB_HEADER_C_5
		#define PID_HCB_MS_HEADER	        	PID_HCB_MS_HEADER_C_5
		#define PID_SYSTEM			          	PID_SYSTEM_C_5
		#define PID_ENVIRONMENT		        	PID_ENVIRONMENT_C_5
		#define PID_PORT_MAP		          	PID_PORT_MAP_C_5
		#define PID_MACHINE_INFO	        	PID_MACHINE_INFO_C_5
		#define PID_USER_MACHINE_ENV	      PID_USER_MACHINE_ENV_C_5
		#define PID_RANGER_CAMERA_BASE    	PID_RANGER_CAMERA_BASE_C_5
		#define PID_RANGER_CAMERA	        	PID_RANGER_CAMERA_C_5
		#define PID_TERMINATION_INFO      	PID_TERMINATION_INFO_C_5
	#else
		#define PID_HCB_DB_HEADER	        	PID_HCB_DB_HEADER_T_5
		#define PID_SPB_DB_HEADER	        	PID_SPB_DB_HEADER_T_5
		#define PID_HCB_MS_HEADER	        	PID_HCB_MS_HEADER_T_5
		#define PID_SYSTEM			          	PID_SYSTEM_T_5
		#define PID_ENVIRONMENT		        	PID_ENVIRONMENT_T_5
		#define PID_PORT_MAP	          		PID_PORT_MAP_T_5
		#define PID_MACHINE_INFO	        	PID_MACHINE_INFO_T_5
		#define PID_USER_MACHINE_ENV      	PID_USER_MACHINE_ENV_T_5
		#define PID_RANGER_CAMERA_BASE    	PID_RANGER_CAMERA_BASE_T_5
		#define PID_RANGER_CAMERA		        PID_RANGER_CAMERA_T_5
		#define PID_TERMINATION_INFO      	PID_TERMINATION_INFO_T_5
	#endif
#else
	#define PID_HCB_DB_HEADER		     PID_HCB_DB_HEADER_T_3
	#define PID_SPB_DB_HEADER		     PID_SPB_DB_HEADER_T_3
	#define PID_HCB_MS_HEADER		     PID_HCB_MS_HEADER_T_3
	#define PID_SYSTEM				       PID_SYSTEM_T_3
	#define PID_ENVIRONMENT			     PID_ENVIRONMENT_T_3
	#define PID_PORT_MAP			       PID_PORT_MAP_T_3
	#define PID_MACHINE_INFO		     PID_MACHINE_INFO_T_3
	#define PID_USER_MACHINE_ENV	   PID_USER_MACHINE_ENV_T_3
	#define PID_RANGER_CAMERA_BASE   PID_RANGER_CAMERA_BASE_T_3
	#define PID_RANGER_CAMERA		     PID_RANGER_CAMERA_T_3
	#define PID_TERMINATION_INFO	   PID_TERMINATION_INFO_T_3
#endif // end if VER5




#define PROJECT_ID_ELMA_100		(('E' << 24) | ('M' << 16) | ('1' << 8) | '0')
#define PROJECT_NAME_ELMA_100	"TVM_Applications"
#define HCB_PROGRAM_REV			106
#define SPB_PROGRAM_REV			105

typedef struct
{
	unsigned int ProjectID;
	unsigned int ProgramRev;	// demands on program source code
	unsigned int reserved1[2];
	char ProjectName[16];
	char reserved2[32];
} THCBProgramHeader;		// common 64 bytes low-level header

typedef struct
{
	unsigned int DataRev;	// demands on data structure
	unsigned int reserved1[3];
	char reserved2[16];
} THCBDBHeader;		// common 32 bytes low-level header

typedef struct
{
	char MachineName[16];
} THCBMachineSpecificHeader;

typedef struct
{
	unsigned int ProjectID;
	unsigned int ProgramRev;	// demands on program source code
	unsigned int reserved1[2];
	char ProjectName[16];
	char reserved2[32];
} TSPBProgramHeader;		// common 64 bytes low-level header

typedef struct
{
	unsigned int DataRev;	// demands on data structure
	unsigned int reserved1[3];
	char reserved2[16];
} TSPBDBHeader;		// common 32 bytes low-level header

typedef struct
{
	unsigned char VersionL;
	unsigned char VersionH;
	unsigned char reserved[2];
} TSPBFPGAVersion;

typedef struct
{
	unsigned int BREnabled;
	unsigned int ProgramID;
	unsigned int Reserved[2];
} TBootRecord;

/* Error type */
#define ERROR_TYPE_CRITICAL			0x0100
#define ERROR_TYPE_WARNING			0x0200
#define ERROR_TYPE_MESSAGE			0x0300
#define ERROR_TYPE_DEBUG			0x0400
#define ERROR_TYPE_USER_NOTIFY		0x0500

/************************************************************************************/
/* Error Code       																*/
/************************************************************************************/
typedef unsigned int TErrorCode;

#define ERROR_CODE_NONE							0x00000000

//   
#define ERROR_CODE_CHECKSUM						0x00000002
#define ERROR_CODE_ALREADY_PACKET				0x00000007
#define ERROR_CODE_WRONG_SIZE					0x00000008
// ProcessUnit  
#define ERROR_CODE_NOTMATCH						0x00000083
//    
#define ERROR_CODE_OVERFLOW						0x00000106
#define ERROR_CODE_FLASH_OPEN					0x00000200
#define ERROR_CODE_FLASH_READ					0x00000201
#define ERROR_CODE_FLASH_WRITE					0x00000202
#define ERROR_CODE_ENVIRONMENT_NOT_MATCH		0x00000203
#define ERROR_CODE_TIMER_OVERLAP				0x00000204
// MCBSP error
#define ERROR_CODE_MCBSP_WRONG_SIZE				0x00000300
#define ERROR_CODE_MCBSP_MULTIPLE_RESPONSE		0x00000301
#define ERROR_CODE_MCBSP_TX_NOT_EMPTY			0x00000302
#define ERROR_CODE_MCBSP_TX_CANNOT_WRITE		0x00000303
#define ERROR_CODE_MCBSP_TRANSMIT_TIMEOUT		0x00000304
#define ERROR_CODE_MCBSP_BUFFER_OVERFLOW		0x00000306
#define ERROR_CODE_MCBSP_RETRY_COUNT_OVER		0x00000307
// HPI error
#define ERROR_CODE_HPI_CPB_INT_STATE			0x00000400
#define ERROR_CODE_HPI_READ_TIMEOUT				0x00000401
#define ERROR_CODE_HPI_RETRY_EXCEEDED			0x00000402
#define ERROR_CODE_HPI_RLI_TIMEOUT				0x00000403
#define ERROR_CODE_HPI_SI_TIMEOUT				0x00000404
#define ERROR_CODE_HPI_SLI_TIMEOUT				0x00000405
#define ERROR_CODE_HPI_RECEIVE					0x00000406

// capture error
#define ERROR_CODE_CAPTURE_TIMEOUT				0x00000500
#define ERROR_CODE_CAPTURE_UNWANTED_INT			0x00000501
#define ERROR_CODE_CAPTURE_JOB_FULL				0x00000502
#define ERROR_CODE_CAPTURE_DMA_TABLE_OVERFLOW	0x00000503
#define ERROR_CODE_CAPTURE_OVERFLOW				0x00000504

// cpb process error
#define ERROR_CODE_CPB_BOARD_DOWN				0x00000600
#define ERROR_CODE_CPB_PROCESS_TIMEOUT			0x00000601

#define ERROR_CODE_PROCESS_RUNTIME				0x00000700
#define ERROR_CODE_PROCESS_WRONG_RESULT			0x00000701

// usb error
#define ERROR_CODE_USB_EP0_STALL				0x00000800

// hcb
#define ERROR_CODE_SERVO_NAK					0x00100700
#define ERROR_CODE_SERVO_ALRAM					0x00100701
#define ERROR_CODE_SERVO_COM_TIMEOUT			0x00100702
#define ERROR_CODE_SERVO_WRONG_CODE				0x00100703

#define ERROR_CODE_STEPMOTOR_BUSY				0x00100800



// user notify error
#define ERROR_CODE_FEEDER_POS_NOT_READY			0x00000001
#define ERROR_CODE_FEEDER_NOT_STOP				0x00000002
#define ERROR_CODE_MACHINE_NOT_STOP				0x00000003
#define ERROR_CODE_MACHINE_NOT_READY			0x00000004


/************************************************************************************/
/* StatusList 	    															*/
/************************************************************************************/
#define MACHINE_STATE_STOP							0
#define MACHINE_STATE_RUN							1
#define MACHINE_STATE_CLEANING						2
#define MACHINE_STATE_ATTACHING						3
#define MACHINE_STATE_DETACHING						4
#define MACHINE_STATE_STARTING						5
#define MACHINE_STATE_STOPPING						6
//#define MACHINE_STATE_SUSPEND						7
#define MACHINE_STATE_EMERGENCY_STOP				8

#define MACHINE_SUSPEND_REASON_FEEDER_EMPTY			0
#define MACHINE_SUSPEND_REASON_FEEDER_TROUBLE		1
#define MACHINE_SUSPEND_REASON_DEFECT				2
#define MACHINE_SUSPEND_REASON_UNINSPECT			3
#define MACHINE_SUSPEND_REASON_TIMEOUT				4
#define MACHINE_SUSPEND_REASON_TABLET_DISAPPEAR		5
#define MACHINE_SUSPEND_REASON_REGULATOR			6
#define MACHINE_SUSPEND_REASON_BLOWER_OL			7
#define MACHINE_SUSPEND_REASON_VD1_STALL			8
#define MACHINE_SUSPEND_REASON_VD2_STALL			9
#define MACHINE_SUSPEND_REASON_GP_COUNT_REACHED		10
#define MACHINE_SUSPEND_REASON_BRIGHTNESS_DOWN		11
#define MACHINE_SUSPEND_REASON_DOOR_OPEN			12
#define MACHINE_SUSPEND_REASON_DP_COUNT_REACHED		13
#define MACHINE_SUSPEND_REASON_UP_COUNT_REACHED		14
#define MACHINE_SUSPEND_REASON_VISION_SENSOR_1		15
#define MACHINE_SUSPEND_REASON_VISION_SENSOR_2		16
#define MACHINE_SUSPEND_REASON_TIME_OVER			17

#define MACHINE_EMERGENCY_REASON_USER_SWITCH		0
#define MACHINE_EMERGENCY_REASON_REGULATOR_LOW		1
#define MACHINE_EMERGENCY_REASON_RINGBLOWER			2


//#define HCB_SL_MACHINE_ALARM_SHIFT				0
//#define HCB_SL_MACHINE_ALARM_MASK				0x00000001

//#define HCB_SL_MACHINE_WARNING_SHIFT			1
//#define HCB_SL_MACHINE_WARNING_MASK				0x00000002

//#define HCB_SL_MACHINE_STATUS_SHIFT				4
//#define HCB_SL_MACHINE_STATUS_MASK				0x000000F0

//#define HCB_SL_MACHINE_SUSPENDED_SHIFT			8
//#define HCB_SL_MACHINE_SUSPENDED_MASK			0x00000100

//#define HCB_SL_MACHINE_SUSPEND_REASON_SHIFT		9
//#define HCB_SL_MACHINE_SUSPEND_REASON_MASK		0x00007E00

/*
#define SL_BOARD_DOWN_SHIFT				0				// 1  Ұ  üũ
#define SL_BOARD_DOWN_MASK 				0x00000001

#define SL_MONITOR_SHIFT				1				// 1:  monitor  , 0:  app.  
#define SL_MONITOR_MASK   				0x00000002

#define SL_ERROR_LIST_SHIFT				2				// errorList  ִٴ ǹ
#define SL_ERROR_LIST_MASK   			0x00000004

#define SL_DEFECT_IMAGE_SHIFT			3				// defectImage  ִٴ ǹ
#define SL_DEFECT_IMAGE_MASK   			0x00000008

#define SL_RESULT_QUEUE_FULL_SHIFT		4				// heap   1 (̸ )
#define SL_RESULT_QUEUE_FULL_MASK   	0x00000010

#define SL_SETUP_SHIFT					5				// setup ϷḦ ˸( result Ƿ ǹ?)
#define SL_SETUP_MASK   				0x00000020

#define SL_INSPECTION_SHIFT				6				// SPB μ Ÿ
#define SL_INSPECTION_MASK   			0x00000040

#define SL_SINGLE_DATA_SHIFT			7				// single data ߻ 
#define SL_SINGLE_DATA_MASK				0x00000080		

#define SL_INSPECTION_RESULT_SHIFT		8				// inspection result ߻ 
#define SL_INSPECTION_RESULT_MASK		0x00000100
*/

#define SL_CPB_PROCESSING_SHIFT			11				// CPB's image processing status (2 bit)
#define SL_CPB_PROCESSING_MASK			0x00001800

#define	SL_CPB_PROCESSING_READY			0
#define	SL_CPB_PROCESSING_SENDDATA		1
#define	SL_CPB_PROCESSING_RUNNING		2
#define	SL_CPB_PROCESSING_FINISHED		3


//************************************************************************************/
// Etc				
//************************************************************************************/
#define CAPTURE_MODE_NONE					0x000
#define CAPTURE_MODE_DEFAULT				0x001
#define CAPTURE_MODE_FRAME					0x002
//#define CAPTURE_MODE_PROCESSING				0x004
#define CAPTURE_MODE_CONTINUOUS				0x010
#define CAPTURE_MODE_PARTIAL				0x020
#define CAPTURE_MODE_MACHINE_CAPTURE		0x100

#define CAPTURE_TYPE_NONE				0
#define CAPTURE_TYPE_SINGLE_CAPTURE		1
#define CAPTURE_TYPE_FULL_CAPTURE		2
#define CAPTURE_TYPE_PROCESSING			3

#define CAPTURE_KIND_FRAME				0
#define CAPTURE_KIND_LINE				1

typedef struct
{
	unsigned short MajorVersion;
	unsigned short MinorVersion;
	unsigned short Release;
	unsigned short Type;
} TProgramVersion;


#define HCB_SPB_COMPATIBILITY_SPB04		0
#define HCB_SPB_COMPATIBILITY_SPB06		1

typedef struct
{
	unsigned char SPBCompatibility;
	unsigned char reserved[3];
} THCBCompatibility;	

#define SPB_BOARD_KIND_SPB04			0
#define SPB_BOARD_KIND_SPB06			1

typedef struct
{
	unsigned char TargetSPBBoardKind;
	unsigned char reserved[3];
	unsigned int ProcDSVersion;
	unsigned int CPBProcDSVersion;
	unsigned int CPBAlgMajorVersion;
	unsigned int CPBAlgMinorVersion;
} TSPBCompatibility;

typedef struct
{
	unsigned int ProcDSVersion;
	unsigned int AlgMajorVersion;
	unsigned int AlgMinorVersion;
} TCPBCompatibility;

#define CPB_CPU_CLOCK_KIND_900		0
#define CPB_CPU_CLOCK_KIND_1100		1

typedef struct
{
	unsigned char SPBIndex;
	unsigned char CamIndex;
	unsigned short CameraInspectPosition;
} TCameraMapInfo;

#define SPB_IMAGE_TRANSFER_METHOD_CHECKSUM			0
#define SPB_IMAGE_TRANSFER_METHOD_NO_CHECKSUM		1

typedef struct
{
	int DefaultCPBProgramID;
	unsigned char CPBEnabled[SYSTEM_CPB_MAX_COUNT];
	unsigned char CPBSDRSizeType[SYSTEM_CPB_MAX_COUNT];
	int CameraDistributionIndex[SYSTEM_CPB_MAX_COUNT];
	unsigned char CameraHardwarePosition[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char InspectPosition[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned short GlobalCameraIndex[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char CameraKind[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char CamMask;
	unsigned char reserved1[3];
	unsigned char CPBClockKind[SYSTEM_CPB_MAX_COUNT];
	TCameraMapInfo CameraMapInfo[SYSTEM_TOTAL_CAMERA_COUNT];		// save camera map to every spb just for data matching 
	unsigned char ImageTransferMethod;
	unsigned char reserved2[3];
} TSPBSystemSetupData;


typedef struct
{
	unsigned char IsAutoScanMode;
	unsigned char Gain;
	unsigned char ThresholdCount;
	unsigned char OutputSelect;
	unsigned char Median;
	unsigned char Morphology;
	unsigned char MorphologySize;
	unsigned char reserved1[1];
	unsigned short ExposureTime2D;
	unsigned short ExposureTime3D;
	unsigned short LineScanTime;
	unsigned short StartCol;
	unsigned short ColCount;
	unsigned short StartRow;
	unsigned short RowCount;
	unsigned short Threshold1;
	unsigned short Threshold2;
	unsigned short reserved2[1];
} TRanger3DCameraInfo;

#define CAMERA_KIND_CIS							0
#define CAMERA_KIND_RANGER_3D					1

#define CAMERA_POSITION_FRONT_FACE				0
#define CAMERA_POSITION_FRONT_FACE_BACKLIGHT	1
#define CAMERA_POSITION_SIDE_FACE_M45			2
#define CAMERA_POSITION_SIDE_FACE_0				3
#define CAMERA_POSITION_SIDE_FACE_P45			4
#define CAMERA_POSITION_3D						5
#define CAMERA_POSITION_DISCONNECT				6

typedef struct
{
	int SDRSizeType;
	int GlobalCameraIndex;
	int CameraInspectPosition;
}
TCPBSystemSetupData;

#define CPB_STATUS_DISABLED			0
#define CPB_STATUS_BOOT_READY		1
#define CPB_STATUS_BOOTING			2
#define CPB_STATUS_IDLE				3
#define CPB_STATUS_PROCESSING		4

typedef struct
{
	unsigned char Enabled;
	unsigned char IsDown;
	unsigned char Status;
	unsigned char reserved;
} TCPBStatus;


#define MAX_SERVO_MOTOR_COUNT		5
//#define MAX_MOTOR_SPEED_STEP_COUNT	16

#define SD1_MOTOR_INDEX				0
#define SD2_MOTOR_INDEX				1
#define BF_ID_MOTOR_INDEX			2
#define BF_OD_IN_MOTOR_INDEX			3
#define BF_OD_OUT_MOTOR_INDEX			4

#define MAX_STEP_MOTOR_COUNT		5

#define BF_UP_DOWN_MOTOR_INDEX			0
#define BF_IN_OUT_MOTOR_INDEX			1
#define VG1_UP_DOWN_MOTOR_INDEX			2
#define VG2_UP_DOWN_MOTOR_INDEX			3
#define SD2_LEFT_RIGHT_MOTOR_INDEX		4

//#define NC_POS_PARAM_1					(-500)
//#define NC_POS_PARAM_2					(-666.66666667)
//#define NC_POS_PARAM_3					(1000)
//#define NC_POS_PARAM_4					(1000)
//#define NC_POS_PARAM_5					(666.66666667)

#define NC_POS_PARAM_1_MUL					(2000)
#define NC_POS_PARAM_2_MUL					(2000)
#define NC_POS_PARAM_3_MUL					(2000)
#define NC_POS_PARAM_4_MUL					(2000)
#define NC_POS_PARAM_5_MUL					(2000)

#define NC_POS_PARAM_1_DIV					(-4)
#define NC_POS_PARAM_2_DIV					(-3)
#define NC_POS_PARAM_3_DIV					(2)
#define NC_POS_PARAM_4_DIV					(2)
#define NC_POS_PARAM_5_DIV					(3)


#define MACHINE_LAMP_KIND_DISCONNECTED				0
#define MACHINE_LAMP_KIND_NORMAL_TABLET				1
#define MACHINE_LAMP_KIND_SUGAR_COATED_TABLET       2


typedef struct
{
	char WarningExist;
	char HopperEmpty;
	char DefectBinFull;
	char UnInsBinFull;
	char RegulatorWarning;
	char FrontDoorOpen;
	char LeftDoorOpen;
	char RightDoorOpen;
	char BowlFeederSensorDisconnected;
	char SuctionDisk1LampDisconnected;
	char SuctionDisk2LampDisconnected;
} TMachineWarningState;


typedef struct
{
	char AlarmExist;
//	char PCNotConnected;
	char RegulatorError;
	char EmergencyOn;
	char Inverter1Trip;
	char Inverter2Trip;
	char RingBlower3OL;
    char Disk1SuctionLow;
    char Disk2SuctionLow;
	char ServoAlarm;
	char Interlock;
	char Disk1Stall;
	char Disk2Stall;
	char GPFull;
	char DPFull;
	char UPFull;
	char DPRatioOver;
	char UPRatioOver;
	char CritUPRatioOver;
	char Sensor1Error;
	char Sensor2Error;
	char BrightnessDown;
	char StepMotorStall[MAX_STEP_MOTOR_COUNT];
	char reserved[2];
} TMachineAlarmState;

typedef struct
{
	char AlarmExist;
	char GPFull;
	char DPFull;
	char UPFull;
	char DPRatioOver;
	char UPRatioOver;
	char CritUPRatioOver;
	char Sensor1Error;
	char Sensor2Error;
	char BrightnessDown;
	char Timeout;
	char dummy[1];
} TInspectionAlarmState;


typedef struct
{
	int BaseSpeed;
	int AccTime;
	int DecTime;
	int Dir;
//	int TargetSpeed;

//    unsigned char SpeedModifierList[MAX_MOTOR_SPEED_STEP_COUNT];
} TServoMotorData;

/*
typedef struct
{
	TServoMotorData ServoMotorData[MAX_SERVO_MOTOR_COUNT];
} THCBSystemSetupInfo;
*/

typedef struct
{
    int Activated;
    int SensingTime;
    int Ejector1Delay;
    int Ejector1RunTime;
    int Ejector2Delay;
    int Ejector2RunTime;
    int GuideInTime;
    int GuideOutTime;
} TRecoveryInfo1;

typedef struct
{
    int Activated;
    int SensingTime;
    int Ejector1Delay;
    int Ejector1RunTime;
    int Ejector2Delay;
    int Ejector2RunTime;
    int FeederStopTime;
    int ReverseMoveAccTime;
    int ReverseMoveSpeed;
    int ReverseMoveRunTime;
} TRecoveryInfo2;

typedef struct
{
	int Activated;
    int SensingTime;
    int FeederStopTime;
    int ForceMoveAccTime;
    int ForceMoveSpeed;
    int ForceMoveRunTime;
} TRecoveryInfo3;

typedef struct
{
//	int CaptureType;
    int CaptureDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int IlluminatorDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int IlluminatorTime[SYSTEM_MACHINE_CAPTURE_COUNT];
	int CamMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int SensorSPBMask[2];
} TMachineCaptureInfo;

typedef struct
{
	int DefectEjectorDelay;
    int DefectSolDelay;
    int DefectSolMinTime;
    int DefectSolInterval1;
    int DefectSolInterval2;
	int UnInsEjectorDelay;
    int UnInsSolDelay;
    int UnInsSolMinTime;
    int UnInsSolInterval1;
	int UnInsSolInterval2;
	int MisejectActive;
	int MisejectDelay;
	int MisejectRunTime;
	int MisejectActiveDelay;
} TEjectorInfo;

#define MAX_SPEED_TRAINING_MODE_MANUAL		0
#define MAX_SPEED_TRAINING_MODE_AUTO		1

typedef struct
{
//    int EmptySensorIndex;
    int EmptySensorActiveRatio;
//    int FullSensorIndex;
    int FullSensorActiveRatio;
    int StartSpeed; 
	int MaxSpeedTrainingMode;
	int ManualMaxSpeed;
    int ManualModeSensorIndex;
    int ManualModeSensorActiveRatio;
	int MechanicalMinSpeed;
	int MechanicalMaxSpeed;
} TVibrationFeederInfo;

typedef struct
{
	int DoorInterlockEnabled;
	int NCInterlockAValue;
} TInterlockInfo;

typedef struct
{
	unsigned short BuzzerContinuousOn;
	unsigned short BuzzerOnTime;
} TBuzzerInfo;

typedef struct
{
	int EyeProtectionModeEnabled;
	int LEDOnTime;
	int LEDOffDelay;
} TLEDInfo;

typedef struct
{
	int PressureAlarmLevel;
	int VacuumAlarmLevel1;
	int VacuumAlarmLevel2;
	int TemperatureAlarmLevel1;
	int TemperatureAlarmLevel2;
	int TemperatureAlarmLevel3;
	int reserved[2];
} TAlarmSetupInfo;

#define MACHINE_MODE_TEST			0
#define MACHINE_MODE_FREE			1
#define MACHINE_MODE_INTERLOCK		2
#define MACHINE_MODE_PROTECTED		3

#define PC_POWER_MODE_MANUAL    0
#define PC_POWER_MODE_AUTO      1

typedef struct
{
	int MachineDataVersion;
	int MachineMode;
	// power info
	int PC_Power_Mode;
	// capture info
	TMachineCaptureInfo MachineCaptureInfo;
	// ejector info
	TEjectorInfo EjectorInfo;
	TVibrationFeederInfo VFInfo;
	// sensor info
	unsigned int SensorIntervalA;
	unsigned int SensorIntervalB;
	TInterlockInfo InterlockInfo;
	TBuzzerInfo BuzzerInfo;
	TLEDInfo LEDControlInfo;
	double ZeroPositionValue[MAX_STEP_MOTOR_COUNT];
	TServoMotorData ServoMotorData[MAX_SERVO_MOTOR_COUNT];
	TAlarmSetupInfo AlarmSetupInfo;
} TMachineSetupData;

/*
typedef struct
{
	unsigned char OperationState;
	unsigned char FeederEmpty;
	unsigned char Suspended;
	unsigned char SuspendReason;
} TMainMachineStatus;	// ELMA-100 machine status (highest level state)
*/

typedef struct
{
	int Enabled;
	int DustBlower1Interval;
	int DustBlower2Interval;
	int DustBlower3Interval;
	int DustBlower4Interval;
	int DustBlower5Interval;
	int DustBlower1Delay;
	int DustBlower2Delay;
	int DustBlower3Delay;
	int DustBlower4Delay;
	int DustBlower5Delay;
	int DustBlower1BlowTime;
	int DustBlower2BlowTime;
	int DustBlower3BlowTime;
	int DustBlower4BlowTime;
	int DustBlower5BlowTime;
} TUserMachineEnv;


typedef struct
{
	int IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	float TabletLength;
	int SuctionDiskSpeed;
	int StudiedTabletSensorLength;
} TMachineCaptureSetupData;


#define TC_TABLE_CAPACITY		256		//  interval, ʴ ִ ν   Ѵ.

typedef struct
{
	int CountingMode;
	unsigned int Counter;
	unsigned int SubCounter[2];
	unsigned int ElapsedTime;
	float CPS;
	int CPM;
	int IndexTable[TC_TABLE_CAPACITY];
	int OffInterval[TC_TABLE_CAPACITY];
	int OnInterval[TC_TABLE_CAPACITY];
	int CurrentTableIndex;
} TTabletCounter;

typedef struct
{
	unsigned int Counter;
	unsigned int ElapsedTime;
	unsigned int LastCheckingTime;
	unsigned int ElapsedTimeInterval;
	unsigned int IntervalCounter;
	int CPM;
} TSimpleTabletCounter;

#define MAX_OP_TEST_COUNT				16

typedef struct
{
	int TestCount;
	unsigned char OPList[MAX_OP_TEST_COUNT];
	unsigned char IsPhysicalPort[MAX_OP_TEST_COUNT];
	int DelayIntervalList[MAX_OP_TEST_COUNT];
	int OnIntervalList[MAX_OP_TEST_COUNT];
	int OffIntervalList[MAX_OP_TEST_COUNT];
} TOPTestData;

#define SYSTEM_MAX_THERMOMETER_COUNT			3
#define SYSTEM_MAX_PRESSURE_METER_COUNT			3
#define SYSTEM_MAX_INVERTER_COUNT				2

typedef struct
{
	short TemperatureData[SYSTEM_MAX_THERMOMETER_COUNT];
	short HumidityData[SYSTEM_MAX_THERMOMETER_COUNT];
	short Pressure[SYSTEM_MAX_PRESSURE_METER_COUNT];
	short DotPos[SYSTEM_MAX_PRESSURE_METER_COUNT];
	short InverterRPM[SYSTEM_MAX_INVERTER_COUNT];
} TMonitoringInfo;

#define RS485_UNIT_COUNT				8
typedef struct
{
	unsigned int WrongAddressCount[RS485_UNIT_COUNT];
	unsigned int CRCErrorCount[RS485_UNIT_COUNT];
	unsigned int SizeErrorCount[RS485_UNIT_COUNT];
	unsigned int ReceiveTOCount[RS485_UNIT_COUNT];
	unsigned int TXCount[RS485_UNIT_COUNT];
} TRS485DebugInfo;


#define HCB_TABLET_LIST_COUNT			256		// must be power of 2
#define HCB_TABLET_LIST_MASK			255		// HCB_TABLET_LIST_COUNT - 1
//#define CAPUTRE_POSITION_COUNT			6
#define MIN_TABLET_INTERVAL				15

#define SENSOR_STATE_NOT_PASSED			0
#define SENSOR_STATE_PASSED				1

#define TABLET_STATE_READY						0
#define TABLET_STATE_SENSOR_1_PASSED			1
#define TABLET_STATE_CAPTURE_INT_1_TRANSFERRED	2
#define TABLET_STATE_CAPTURE_1_COMPLETE			3
#define TABLET_STATE_SENSOR_2_PASSED			4
#define TABLET_STATE_CAPTURE_INT_2_TRANSFERRED	5
#define TABLET_STATE_RESULT_WAITING				6
#define TABLET_STATE_BLOW_WAITING				7
#define TABLET_STATE_NC_WAITING					8
#define TABLET_STATE_COMPLETE					9
#define TABLET_STATE_ERROR						0xFF

#define TABLET_RESULT_NONE									0
#define TABLET_RESULT_GOOD									1
#define TABLET_RESULT_DEFECT								2
#define TABLET_RESULT_DEFECT_UNPRINT						3
#define TABLET_RESULT_DEFECT_SPB_PROCESSING_NOT_COMPLETE	4
#define TABLET_RESULT_UNINS_SPB_TIMEOUT						5
#define TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE		6
//#define TABLET_RESULT_UNINS_FROM_SPB						7
#define TABLET_RESULT_INSERTED								8
#define TABLET_RESULT_DISAPPEARED							9
//#define TABLET_RESULT_SMALL_SIZE							10
#define TABLET_RESULT_EARLY									11
#define TABLET_RESULT_LATE									12
//#define TABLET_RESULT_MISTAKEN								13
#define TABLET_RESULT_SENSOR_1_MISFEEDING					13
#define TABLET_RESULT_SENSOR_2_MISFEEDING					14
#define TABLET_RESULT_MULTI_TABLET_SENSOR_1					15
#define TABLET_RESULT_MULTI_TABLET_SENSOR_2					16
#define TABLET_RESULT_UNINTENDED_UNINSPECT					17
#define TABLET_RESULT_DEFECT_FR_MISMATCH					18

#define TABLET_RESULT_SPB_MASK								0x1000		// 4096

#define IMAGE_STATE_EMPTY			0
#define IMAGE_STATE_ON_CAPTURE		1
#define IMAGE_STATE_CAPTURED		2
#define IMAGE_STATE_PROCESSING		3
#define IMAGE_STATE_DEFECT			4
#define IMAGE_STATE_UPLOADING		5

#define IMAGE_RESULT_NONE			0
#define IMAGE_RESULT_GOOD			1
#define IMAGE_RESULT_DEFECT			2

typedef struct
{
	int TabletNumber;
	int InspectionResult;
	int State;
	unsigned int Sensor1Time;
	unsigned int CaptureIntTime;
	unsigned int EstimatedSensor2Time;
	int Sensor1Length;
	int IsLEDOn[SYSTEM_MACHINE_CAPTURE_COUNT];
} THCBDisk1TabletUnit;

#define TABLET_EJECTION_NONE			0
#define TABLET_EJECTION_UNINSPECT		1
#define TABLET_EJECTION_DEFECT			2


#define TABLET_EJECTION_CHECK_NONE		0
#define TABLET_EJECTION_CHECK_EMPTY		1
#define TABLET_EJECTION_CHECK_EXIST		2

typedef struct
{
	int TabletNumber;
	int InspectionResult;
	int InspectionResult_SPB[SYSTEM_SPB_COUNT];
	int State;
	unsigned int Sensor1Time;
	unsigned int CaptureIntTime;
	unsigned int EstimatedSensor2Time;
	unsigned int Sensor2Time;
	unsigned int EstimatedSensor3Time;	
	unsigned int Sensor3Time;
	int Sensor1Length;
	int Sensor2Length;
	int Sensor3Length;
	int IsLEDOn[SYSTEM_MACHINE_CAPTURE_COUNT];
	unsigned int DefectEjectorTime;
	unsigned int UnInsEjectorTime;
	int Ejection;
	int EjectionCheck;
} THCBDisk2TabletUnit;


typedef struct
{
	unsigned int Sensor3Time;
	int State;
	int Sensor3Length;
} THCBCounterTabletUnit;
typedef struct
{
//	TTabletUnit TabletList_Sensor1[MAX_TABLET_LIST_COUNT];
//	TTabletUnit TabletList_Sensor2[MAX_TABLET_LIST_COUNT];
	THCBDisk1TabletUnit Disk1TabletList[HCB_TABLET_LIST_COUNT];
	THCBDisk2TabletUnit Disk2TabletList[HCB_TABLET_LIST_COUNT];
	THCBCounterTabletUnit CounterTabletList[HCB_TABLET_LIST_COUNT];

/*
	int MCTabletIndex1;
	int MCTabletIndex2;

	int CaptureTabletIndex1;
	int CaptureTabletIndex2;
*/
	int CurrentTabletNumber;

	int CurrentSensor1ListIndex;	
	int CurrentSensor2ListIndex;
	int CurrentSensor3ListIndex;
	int CurrentRelatedDisk1TabletListIndex;
	int CurrentRelatedDisk2TabletListIndex;

	int CurrentInt1ListIndex;
	int CurrentInt2ListIndex;

	int CurrentCapture1ListIndex;
	int CurrentCapture2ListIndex;

	int PollingResultTabletIndex;
	int PollingBlowTabletIndex;	

	int CounterCheckListIndex;

	unsigned int CounterSensorInsertTimeList[HCB_TABLET_LIST_COUNT];
	unsigned int CounterSensorInsertLengthList[HCB_TABLET_LIST_COUNT];
} TTabletInfo;

typedef struct
{
	int Disk1TabletCount;
	int Disk2TabletCount;
	int TotalTabletCount;
	int GoodTabletCount;
	int DefectTabletCount;
	int UnInsTabletCount;
    int UnPrintTabletCount;

//	unsigned int Counter;
//	unsigned int ElapsedTime;
//	int ThroughPut;

	// unins detail

	int SPBProcessingNCTabletCount;
	int SPBTOTabletCount;
	int SPBUnInsTabletCount;
	int DisappearedTabletCount;
	int InsertedTabletCount;
	int LateTabletCount;
	int EarlyTabletCount;
	int ClosedTabletCount;
    int WrongNumberTabletCount;
    int NumberUndefTabletCount;
    int CaptureNotReadyTabletCount;
    int BufferFullTabletCount;
    int CaptureTimoutTabletCount;
    int ProcessingTimoutTabletCount;
    int CPBFullTabletCount;
	int ProcessingErrorTabletCount;
	int UnInsTabletPositionCount;
	int UnInsBrightnessDropCount;
	int UnInsBrightnessChaseCount;
	int Sensor1MisFeedingTabletCount;
	int Sensor2MisFeedingTabletCount;
	int Sensor1MultiTabletCount;
	int Sensor2MultiTabletCount;
	int UnIntendedUninsTabletCount;
	int CounterSensorTabletCount;
	int MisejectActiveCount;
	int GoodTabletLostCount;
	int MisejectTabletInsertCount;
	int MisejectDefectTabletCount;
	int MisejectUnInsTabletCount;
	int FRMismatchTabletCount;
} TTabletInspectInfo;

typedef struct
{
	int InspectionMode;
	int SPBMask;
	float TabletLength;
	int MachineStopActivated;
	int MachineStopDefectRatio;
	int MachineStopUnInsRatio;
	int CameraMapInfo_SPB[SYSTEM_TOTAL_CAMERA_COUNT];
	int CameraMapInfo_CAM[SYSTEM_TOTAL_CAMERA_COUNT];
	int CheckUnPrint;
	int CheckFrontRear;
	int InspectionNCAsDefect;
	int DesiredGPCount;
	int MachineStopDPCount;
	int MachineStopUPCount;
	int InspectionID;
	int SuctionDiskSpeed;
	int StudiedTabletSensor1Length;
	int StudiedTabletSensor2Length;
	int StudiedTabletSensor3Length;
	int StudiedSensorIntervalA;
	int StudiedSensorIntervalB;
} THCBInspectionOption;


#define RESULT_TABLE_SIZE				256
#define RESULT_TABLE_MASK				255

typedef struct
{
	int TabletNumber;
	int Result;
} TInspectionResultTableUnit;

typedef struct
{
	TInspectionResultTableUnit Table[RESULT_TABLE_SIZE];
	int CurrentIndex;
} TInspectionResultTable;



typedef struct
{
	int RangeLeft[SYSTEM_TOTAL_CAMERA_COUNT];
    int RangeTop[SYSTEM_TOTAL_CAMERA_COUNT];
    int RangeRight[SYSTEM_TOTAL_CAMERA_COUNT];
    int RangeBottom[SYSTEM_TOTAL_CAMERA_COUNT];
} TTabletCaptureSetupData;

typedef struct
{
	int ImageCount;
	unsigned char ImageStatus[2048];
} TProcessingImageBufferData;


typedef struct
{
	unsigned int CaptureMode;
	unsigned char CameraMask;
    unsigned char CaptureKind;
	unsigned char dummy[2];
	unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
    unsigned short CaptureStartX;
    unsigned short CaptureLengthX;
    unsigned short CaptureStartY;
    unsigned short CaptureLengthY;
	int FrameBufferCount;
    int FrameHeight;
} TCaptureCommandParam;

typedef struct
{
//	int Command;
	unsigned int CaptureType;		// single, multi
	unsigned int CaptureMode;
	unsigned char CameraMask;
	unsigned char ContainParams;
    unsigned char dummy[2];	
	unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
	int FrameBufferCount;
} TCaptureSetupData;


#define SPB_TABLET_STATE_NONE						0
#define SPB_TABLET_STATE_FINDING_BUFFER				1
#define SPB_TABLET_STATE_NUMBERING					2
#define SPB_TABLET_STATE_CAPTURE_READY				3
#define SPB_TABLET_STATE_ON_CAPTURE					4
#define SPB_TABLET_STATE_CAPTURED					5
//#define SPB_TABLET_STATE_PROCESSING_READY			6
#define SPB_TABLET_STATE_PROCESSING					7
#define SPB_TABLET_STATE_PROCESSING_COMPLETE		8
#define SPB_TABLET_STATE_ERROR						0xFF


#define SPB_TABLET_RESULT_NONE								0
#define SPB_TABLET_RESULT_PROCESSING						1
#define SPB_TABLET_RESULT_GOOD								2
#define SPB_TABLET_RESULT_DEFECT							3
#define SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL			4
#define SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED		5
#define SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER			6
#define SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT				7
#define SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY			8
#define SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT			9
#define SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR			10
#define SPB_TABLET_RESULT_UNINS_CPB_FULL					11
#define SPB_TABLET_RESULT_UNINS_CLOSED_TABLET				12
#define SPB_TABLET_RESULT_UNINS_TABLET_POSITION				13
#define SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED			14
#define SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE			15
#define SPB_TABLET_RESULT_PROCESSING_MASK					0x0F
#define SPB_TABLET_RESULT_PRINT_IS_MASK						0x10
#define SPB_TABLET_RESULT_FRONT_FACE_MASK					0x20
//#define SPB_TABLET_RESULT_PRINT_MASK						0x70
//#define SPB_TABLET_RESULT_PRINT_IS_CAM1						0x10
//#define SPB_TABLET_RESULT_PRINT_IS_CAM2						0x20
//#define SPB_TABLET_RESULT_PRINT_IS_CAM3						0x40
#define SPB_TABLET_RESULT_THICKERROR_MASK					0x40

//#define SPB_TABLET_RESULT_PRINT_IS_CAM1_SHIFT				4
//#define SPB_TABLET_RESULT_PRINT_IS_CAM2_SHIFT				5
//#define SPB_TABLET_RESULT_PRINT_IS_CAM3_SHIFT				6
#define SPB_TABLET_RESULT_PRINT_IS_SHIFT					4
#define SPB_TABLET_RESULT_FRONT_FACE_SHIFT					5
#define SPB_TABLET_RESULT_PRINT_THICKERROR_SHIFT			6

#define TABLET_INSPECTION_STATE_NONE						0
#define TABLET_INSPECTION_STATE_CAPTURE_WAITING				1
#define TABLET_INSPECTION_STATE_ON_CAPTURE					2
#define TABLET_INSPECTION_STATE_CAPTURED					3
#define TABLET_INSPECTION_STATE_PROCESSING_READY			4
#define TABLET_INSPECTION_STATE_PROCESSING					5
#define TABLET_INSPECTION_STATE_PROCESSING_COMPLETE			6
#define TABLET_INSPECTION_STATE_PASSED						7
#define TABLET_INSPECTION_STATE_CAPTURE_ERROR				8
#define TABLET_INSPECTION_STATE_PROCESSING_ERROR			9

#define TABLET_PROCESSING_RESULT_UNKNOWN					0
#define TABLET_PROCESSING_RESULT_GOOD						1
#define TABLET_PROCESSING_RESULT_DEFECT						2
#define TABLET_PROCESSING_RESULT_ERROR						3
#define TABLET_PROCESSING_RESULT_CPB_FULL					4
#define TABLET_PROCESSING_RESULT_CLOSED_TABLET				5
#define TABLET_PROCESSING_RESULT_UNINS_TABLET_POSITION		6
#define TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_DROPPED	7
#define TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_CHASE		8
#define TABLET_PROCESSING_RESULT_THIN_TABLET				9
#define TABLET_PROCESSING_RESULT_FAT_TABLET                 10

#define SPB_TABLET_LIST_COUNT			256
#define SPB_TABLET_LIST_MASK			255

/*
#define CAMERA_STATE_READY								0
#define CAMERA_STATE_ON_CAPTURE							1
#define CAMERA_STATE_COMPLETE							2
#define CAMERA_STATE_OVERLAPPED							3
#define CAMERA_STATE_COMPLETE_OVERLAP_FIRST				4
#define CAMERA_STATE_DOUBLE_OVERLAPPED					5
#define CAMERA_STATE_COMPLETE_DOUBLE_OVERLAP_FIRST		6
#define CAMERA_STATE_ERROR								7
*/
#define RANGER_CAMERA_COMMAND_RESULT_NONE			0
#define RANGER_CAMERA_COMMAND_RESULT_OK				1
#define RANGER_CAMERA_COMMAND_RESULT_COM_TIMEOUT	2
#define RANGER_CAMERA_COMMAND_RESULT_COM_ERROR		3



#define TABLET_PROCESSING_MODE_NONE				0
#define TABLET_PROCESSING_MODE_CALIBRATION		1
#define TABLET_PROCESSING_MODE_STUDY			2
#define TABLET_PROCESSING_MODE_INSPECTION		3

typedef struct
{
//	int CaptureOccured;
//	int CaptureState[SYSTEM_SPB_CAMERA_COUNT];
	int State;
	int Result;
	int ImageFrameIndex;
	int ResultReported;
	unsigned char *CaptureImagePtr[SYSTEM_SPB_CAMERA_COUNT];
	int CalibCaptureFrameIndex[SYSTEM_SPB_CAMERA_COUNT];
	int CaptureStatus[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int TabletNumber;
	unsigned int CaptureIntTime;
	unsigned int ProcessingStartTime[SYSTEM_SPB_CAMERA_COUNT];
//	unsigned int LastCaptureTime;	
	int InspectionState[SYSTEM_SPB_CAMERA_COUNT];
	int ProcessingResult[SYSTEM_SPB_CAMERA_COUNT];
	int PrintResult[SYSTEM_SPB_CAMERA_COUNT];
	int ThickErrorSW[SYSTEM_SPB_CAMERA_COUNT];
	int Front_Rear[SYSTEM_SPB_CAMERA_COUNT];
} TSPBTabletUnit;



#define MAX_TABLET_NUMBER			1000000000


typedef struct
{
	TSPBTabletUnit TabletList[SPB_TABLET_LIST_COUNT];
//	unsigned int TabletNumber;
	unsigned int ExpectedNextTabletNumber;
	int NextCaptureListIndex;
	int FindingBufferListIndex;
	int NumberingCaptureListIndex;
	int PollingCaptureListIndex;
//	int PollingCaptureEndListIndex;
//	int ProcessingTabletListIndex;
//	int ProcessingResultListIndex;
	int PollingCaptureEndListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int PollingCaptureAllEndListIndex;
	int ProcessingTabletListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int ProcessingAllTabletListIndex;
	int ProcessingResultListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int ProcessingResultCheckingListIndex;
	int ProcessingResultReportingListIndex;

//	int DiscSpeed[2];
	int DiscBaseSpeed[2];
	int DiscTargetSpeed[2];
	int CaptureMode;
	int ProcessingMode;
	// tablet number
	int TabletNumberRequestOn;	
	int TabletNumberReceived;
	unsigned int ReceivedTabletNumber;

} TSPBTabletProcessInfo;


#define SPB_PROCESSING_RESULT_COUNT		8

typedef struct
{
	int CompleteCount;
	unsigned char ProcessingResult[SPB_PROCESSING_RESULT_COUNT];
	int ProcessedTabletNumber[SPB_PROCESSING_RESULT_COUNT];
} TSPBProcessingResultData;


typedef struct
{
	int TabletNumber;
	unsigned int CaptureStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int CaptureEndTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ImageSendStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ProcessingStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int BeforePollingTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ProcessingEndTime[SYSTEM_SPB_CAMERA_COUNT];
	int ProcessingCPB[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int CompleteTime;	
} TProcessingTime;

#define SPB_SETUP_MODE_STUDY				0
#define SPB_SETUP_MODE_INSPECTION			1
#define SPB_SETUP_MODE_GRADE_CHANGE			2

#define PROCESSING_SETUP_KIND_NONE			0
#define PROCESSING_SETUP_KIND_STUDY			1
#define PROCESSING_SETUP_KIND_INSPECTION	2
#define PROCESSING_SETUP_KIND_GRADE_CHANGE	3

#define PROCESSING_SETUP_STEP_NONE			0
#define PROCESSING_SETUP_STEP_READY			1
#define PROCESSING_SETUP_STEP_WAITING		2
#define PROCESSING_SETUP_STEP_INIT			3
#define PROCESSING_SETUP_STEP_SETUP			4
#define PROCESSING_SETUP_STEP_COM_WAITING	5
#define PROCESSING_SETUP_STEP_CLEAR			6
#define PROCESSING_SETUP_STEP_COMPLETE		7

#define PROCESSING_SETUP_CPB_STEP_NONE		0
#define PROCESSING_SETUP_CPB_STEP_READY		1
#define PROCESSING_SETUP_CPB_STEP_COMPLETE	2
#define PROCESSING_SETUP_CPB_STEP_FAIL		3
#define PROCESSING_SETUP_CPB_STEP_INVALID	4
typedef struct
{
	char SetupKind;
	char SetupStep;	
	char AvailCPBCount;
	char SetupCPBCount;
	char FailCPBCount;
	char CurrentCPBIndex;
	char dummy[2];
	char CPBStep[SYSTEM_CPB_COUNT];
	unsigned int WaitingStartTime;
} TSPBProcessingSetupInfo;


#define VFINFO_LIST_COUNT		32
#define VFINFO_LIST_MASK		31

typedef struct
{
	short VFSpeedList[VFINFO_LIST_COUNT];
	short VFMaxSpeedList[VFINFO_LIST_COUNT];
	short VFSensor1RatioList[VFINFO_LIST_COUNT];
	short VFSensor2RatioList[VFINFO_LIST_COUNT];
//	int CurrentManualListIndex;

 	short NowSpeedList[VFINFO_LIST_COUNT];
	short AverageSpeedList[VFINFO_LIST_COUNT];
	short AverageSensor1RatioList[VFINFO_LIST_COUNT];	
	int CurrentListIndex;
    int SetRatio1;
	int SetRatio2;
	int Sensor1ON_NowRatio;
	int Sensor2ON_NowRatio;
	int test;
    int test1;
	int test2; 
	int test3;
	int test4;
	unsigned short NowSpeed;	
} TVibratorInfo;
/*
typedef struct
{
	short NowSpeedList[VFINFO_LIST_COUNT];
	short AverageSpeedList[VFINFO_LIST_COUNT];
	short RatioList[VFINFO_LIST_COUNT];
	int CurrentListIndex;
    int SetRatio1;
	int SetRatio2;
	int Sensor1ON_NowRatio;
    int Sensor2ON_NowRatio;
    int test1;
	int test2; 
	int test3; 
	int test4; 
	unsigned short NowSpeed;
    unsigned short AverageSpeed;
    unsigned short AverageRatio;
}TChul_VFInfo;
*/
typedef struct
{
	
 	int Change_Ratio;
} TChul_VFData;

typedef struct
{
	int DataValid;
	int InspectionID;
	TTabletInspectInfo InspectionInfo;
} TTerminationInfo;

typedef struct
{
	int DefectExists;
	int DefectTabletNumber;
	int DefectCameraMask[SYSTEM_SPB_CAMERA_COUNT];
} TDefectImageInfo;

#define CPB_PROCESSING_TIME_LIST_COUNT      32

typedef struct
{
    int ProcessingTimeList[CPB_PROCESSING_TIME_LIST_COUNT];

} TCPBProcessingInfo;

#define CPB_REV_003							3
#define CPB_REV_004							4

typedef struct
{
	unsigned char CPBRevInfo[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];

} TSPBSystemInfo;

typedef struct
{
	unsigned short Version;
	unsigned short PartNumber;
	unsigned short Manufacturer;
	unsigned char InfoValid;  
	unsigned char IsC64PlusDevice;
} TCPBDeviceInfo;

typedef struct
{
	int Length;
	char Data[4092];
} TRangerCameraParamData;

#define IDLE_PROCESS_LIST_COUNT		256
#define IDLE_PROCESS_LIST_MASK		255
typedef struct
{
	int CurrentIndex;
	unsigned int CurrentTime;
	unsigned int Time[IDLE_PROCESS_LIST_COUNT];
	unsigned int TimeCounter[IDLE_PROCESS_LIST_COUNT];	
	unsigned int Min50usCount[IDLE_PROCESS_LIST_COUNT];
	unsigned int Max50usCount[IDLE_PROCESS_LIST_COUNT];
} TIdleProcessData;

typedef struct
{
	unsigned char Activated;
	unsigned char InspectionStopBuzzerOn;
	unsigned char InspectionStopMachinePowerOff;
	unsigned char TimerEnabled;
	unsigned int MachinePowerOffDelay;
	unsigned int BuzzerOnTime;
	unsigned int InspectionStopTimer;
} TUnmanedOperationData;

#define ERROR_VALUE_MAX_SIZE			3			/* integer	 3			*/

typedef struct
{
	unsigned short 	troubleBoard;					/* ߻  id */
	unsigned short 	type;
	unsigned int	time;
	unsigned int 	code;							/* error code */
	unsigned int 	value[ERROR_VALUE_MAX_SIZE];	/* [] */
} TErrorUnit;

/************************************************************************************/
/* Common Function																	*/
/************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

unsigned int CheckSum(unsigned int *src, unsigned int len);
int SizeOfWord(int size);

#ifdef __cplusplus
}
#endif

#endif
